import random
import tkinter as tk
from PIL import Image, ImageTk

app = tk.Tk()
app.title('กินไรดี')

# โหลดรูปทั้งหมด
radnha = Image.open("radnha.png").resize((200, 200))
kowpud = Image.open("kowpud.png").resize((200, 200))
krapow = Image.open("krapow.png").resize((200, 200))

food_radnha = ImageTk.PhotoImage(radnha)
food_kowpud = ImageTk.PhotoImage(kowpud)
food_krapow = ImageTk.PhotoImage(krapow)

foods = [
    ("ข้าวผัด", food_kowpud),
    ("ราดหน้า", food_radnha),
    ("กระเพราไก่ไข่ดาว", food_krapow)
]

# Label แสดงรูป และข้อความ
label_img = tk.Label(app)
label_img.grid(row=0, column=1)

label_text = tk.Label(app, text="", font=("Tahoma", 16), fg="red")
label_text.grid(row=1, column=1)

animation_running = False   # ป้องกันกดรัว

# -----------------------------
# ฟังก์ชัน Animation
# -----------------------------
def animate(count):
    global animation_running
    
    if count <= 0:
        animation_running = False
        show_final()
        return
    
    name, img = random.choice(foods)
    label_img.config(image=img)
    label_img.image = img
    
    app.after(80, lambda: animate(count - 1))


# -----------------------------
# แสดงผลลัพธ์สุดท้าย
# -----------------------------
def show_final():
    name, img = random.choice(foods)
    label_img.config(image=img)
    label_img.image = img
    label_text.config(text=name)


# -----------------------------
# เมื่อกดปุ่ม
# -----------------------------
def clicked():
    global animation_running
    if animation_running:
        return

    animation_running = True
    animate(15)  # จำนวนครั้งที่เปลี่ยนภาพระหว่าง animation


# ปุ่มสุ่ม
tk.Button(app, command=clicked, text="สุ่มอาหาร", bg="green", font=("Tahoma", 25)).grid(row=2, column=1)

app.geometry("500x500")
app.mainloop()
